##!/bin/bash
#功能：zabbix-server侧，低级自动发现脚本，发现远端主机的指定“端口”是否存活
#优点：勉去每个主机发送脚本，且适配win/linux主机，仅需远端开启一个键值：system.run[*]
#缺点：需要确定每个主机的具体的端口号

#低级自动发现键：{#REMOTE_IPADD}   {#REMOTE_PORT} {#REMOTE_PORT_TYPE}

#要监控的进程路径（自动适配，先判断文件是否存在，若存在就监控进程！）
#START_SRC_VAR（切勿删除本行注释）
<<EOF
#临时取消某条记录使用"#"号注释，进程区分大小写！！！(多个端口，使用英文逗号','分割)
#REMOTE_IPADD             	TCP:REMOTE_PORT   				UDP:REMOTE_PORT
127.0.0.1 					TCP:88,3306,9000,3000								
192.168.61.133												UDP:68
192.168.61.134				TCP:3389,80						UDP:1234,4000
#192.168.61.135				TCP:12345
EOF
#END_SRC_VAR（切勿删除本行注释）
######################################################
#sh
SHPATH=`readlink -f $0`
SHDIR=`dirname $SHPATH`
SHNAME=`echo $SHPATH|awk  -F '/' '{print $NF}'`

#date
DATE_F=`date +%F`
DATE_FT=`date +%F_%T`
DATE_FHMS=`date +%F_%H%M%S`

#dir
OUT_DIR=$SHDIR/out/$SHNAME
TMP_DIR=$SHDIR/temp/$SHNAME
LOG_DIR=$SHDIR/logs/$SHNAME
mkdir -p $OUT_DIR $TMP_DIR $LOG_DIR

#file
LOG_FILE=$LOG_DIR/$DATE_F.log


#获取要监控的进程
sed -n '/^#START_SRC_VAR/,/^#END_SRC_VAR/'p $SHPATH |grep -Ev '^#|^$|EOF' >$TMP_DIR/src_var.txt

#json开始
echo '
{
	"data":
	[
' > $OUT_DIR/out_json.txt
#json中间部分
while read LINE
do
	
	LINE_IPADD=`echo $LINE|awk '{print $1}'`
	#插入数据，TCP端口
	for i in `echo $LINE|tr ' ' '\n'|grep TCP|tr ',' '\n'|sed 's/TCP://g'`
	do
		
		#插入头{
		echo -e '\t\t {' >> $OUT_DIR/out_json.txt
		echo -e "\t\t \"{#REMOTE_IPADD}\":\"$LINE_IPADD\"," 	>> $OUT_DIR/out_json.txt
		echo -e "\t\t \"{#REMOTE_PORT_TYPE}\":\"TCP\"," 			>> $OUT_DIR/out_json.txt
		echo -e "\t\t \"{#REMOTE_PORT}\":\"$i\"" 				>> $OUT_DIR/out_json.txt
		#插入尾}
		echo -e '\t\t }' >> $OUT_DIR/out_json.txt
		echo -e '\t\t ,' >> $OUT_DIR/out_json.txt
		
	done
	#插入数据，UDP端口	
	for i in `echo $LINE|tr ' ' '\n'|grep UDP|tr ',' '\n'|sed 's/UDP://g'`
	do
		
		#插入头{
		echo -e '\t\t {' >> $OUT_DIR/out_json.txt
		echo -e "\t\t \"{#REMOTE_IPADD}\":\"$LINE_IPADD\"," 	>> $OUT_DIR/out_json.txt
		echo -e "\t\t \"{#REMOTE_PORT_TYPE}\":\"UDP\"," 			>> $OUT_DIR/out_json.txt
		echo -e "\t\t \"{#REMOTE_PORT}\":\"$i\"" 			>> $OUT_DIR/out_json.txt
		#插入尾}
		echo -e '\t\t }' >> $OUT_DIR/out_json.txt
		echo -e '\t\t ,' >> $OUT_DIR/out_json.txt
		
	done

done < $TMP_DIR/src_var.txt
sed -i '$d' $OUT_DIR/out_json.txt
#json结束
echo '
	]
}
' >> $OUT_DIR/out_json.txt

cat $OUT_DIR/out_json.txt |tr '\n' ' '|tr -d '\t'
echo 





