#!/bin/bash
#功能：zabbix-ser监控客户端指定进程是否存在，使用键值system.run[*]+bat/shell命令实现！
#适配win/linux
#检测agent端，端口是否存活



#被检测的IP
IPADD=$1
#被检测的端口协议
TYPE=$2
#被检测的端口号
PORT=$3
#客户端端口号（默认10050）
AGENT_PORT=10050
##################################################
#sh
SHPATH=`readlink -f $0`
SHDIR=`dirname $SHPATH`
SHNAME=`echo $SHPATH|awk  -F '/' '{print $NF}'`

#date
DATE_F=`date +%F`
DATE_FT=`date +%F_%T`
DATE_FHMS=`date +%F_%H%M%S`

#dir
LOG_DIR=$SHDIR/logs/$SHNAME
mkdir -p $OUT_DIR $TMP_DIR $LOG_DIR

#file
LOG_FILE=$LOG_DIR/$DATE_F.log

#超时时间
TM_OUT=2
#获取系统版本，判断命令
OS_VAR=`timeout $TM_OUT zabbix_get -s $IPADD -p $AGENT_PORT -k system.uname|awk '{print $1}'|tr '[:upper:]' '[:lower:]'`

#检测3次
for i in `seq 3`
do
#根据系统执行命令
case $OS_VAR in
	windows)
	PROT_VAR=`timeout $TM_OUT zabbix_get -s $IPADD -p $AGENT_PORT -k system.run["netstat -an"]|grep -i $TYPE|awk -F ':' '{print $2}'|awk '{print $1}'|grep -v ^$|sort -u`
	;;

	linux)
	PROT_VAR=`timeout $TM_OUT zabbix_get -s $IPADD -p $AGENT_PORT -k system.run["ss -tunl"]|grep -i $TYPE|awk '{print $5}'|awk -F ':' '{print $NF}'|sort -u`
	;;
esac
#判断端口是否存活
if [ ! -z  "$PROT_VAR" ];then 
	echo $PROT_VAR |grep "$PORT"  >/dev/null
	if [ $? -eq 0 ];then 
		STAT=online 
		break
	else
		echo $PROT_VAR |grep 'Unknown metric' >/dev/null
		if [ $? -eq 0 ];then STAT='Unknown_metric';else STAT=error;fi
	fi
else
STAT=offline
fi 
sleep 1
let i++
done
echo $STAT 
#打印到日志
###补充长度,方便排版
BLANK='                    '
#IP获取长度
IP_LENGTH=${#IPADD}
#IP待补充长度
IP_BLANK_NUM=$((15-IP_LENGTH))
NEW_IPADD="$IPADD${BLANK:0:IP_BLANK_NUM}"

#状态获取长度
STAT_LENGTH=${#STAT}
#状态待补充长度
STAT_BLANK_NUM=$((15-STAT_LENGTH))
NEW_STAT="$STAT${BLANK:0:STAT_BLANK_NUM}"

echo "$DATE_FT 	CHECK_NUM:$i 	IP:$NEW_IPADD 	STAT:$NEW_STAT 	TYPE:$TYPE 	PORT:$PORT"  >> $LOG_FILE



