#!/bin/bash
#先删除虚拟机再创建虚拟机



# 源虚拟机信息
SOURCE_DATASTORE="WD_1T_1"
SOURCE_VM_NAME="WIN10_21H2_WYY"
SOURCE_VM_PATH="/vmfs/volumes/${SOURCE_DATASTORE}/${SOURCE_VM_NAME}"

# 目标虚拟机信息
TARGET_DATASTORE="WD_1T_1"
TARGET_VM_NAME="WIN10_21H2_DEMO"
TARGET_VM_PATH="/vmfs/volumes/${TARGET_DATASTORE}/${TARGET_VM_NAME}"
#########################################################
###删除虚拟机
VMID_DEL=`vim-cmd vmsvc/getallvms|grep "$TARGET_VM_NAME"|awk '{print $1}'`
if [ ! -z $VMID_DEL ];then
        vim-cmd vmsvc/power.off  $VMID_DEL
        vim-cmd vmsvc/power.off  $VMID_DEL
        vim-cmd vmsvc/unregister $VMID_DEL
fi
rm -rf $TARGET_VM_PATH



###创建目标虚拟机目录
mkdir -p ${TARGET_VM_PATH}

# 克隆磁盘
vmkfstools -i ${SOURCE_VM_PATH}/${SOURCE_VM_NAME}.vmdk ${TARGET_VM_PATH}/${TARGET_VM_NAME}.vmdk -d thin

# 克隆配置文件
cp ${SOURCE_VM_PATH}/${SOURCE_VM_NAME}.vmx ${TARGET_VM_PATH}/${TARGET_VM_NAME}.vmx

# 修改配置文件中的磁盘路径
#sed -i "s|${SOURCE_VM_NAME}.vmdk|${TARGET_VM_NAME}.vmdk|g" ${TARGET_VM_PATH}/${TARGET_VM_NAME}.vmx
sed -i "/scsi0:0.fileName/c scsi0:0.fileName = \"${TARGET_VM_NAME}.vmdk\"" ${TARGET_VM_PATH}/${TARGET_VM_NAME}.vmx
# 修改配置文件中的虚拟机名称
sed -i "s|displayName = \"${SOURCE_VM_NAME}\"|displayName = \"${TARGET_VM_NAME}\"|g" ${TARGET_VM_PATH}/${TARGET_VM_NAME}.vmx

# 生成新的 UUID
NEW_UUID=$(openssl rand -hex 16 | sed 's/\(........\)\(....\)\(....\)\(....\)\(............\)/\1-\2-\3-\4-\5/')
NEW_UUID_PART1=$(echo $NEW_UUID | cut -d'-' -f1 | sed 's/\(..\)\(..\)\(..\)\(..\)/\1 \2 \3 \4/')
NEW_UUID_PART2=$(echo $NEW_UUID | cut -d'-' -f2 | sed 's/\(..\)\(..\)/\1 \2/')
NEW_UUID_PART3=$(echo $NEW_UUID | cut -d'-' -f3 | sed 's/\(..\)\(..\)/\1 \2/')
NEW_UUID_PART4=$(echo $NEW_UUID | cut -d'-' -f4 | sed 's/\(..\)\(..\)/\1 \2/')
NEW_UUID_PART5=$(echo $NEW_UUID | cut -d'-' -f5 | sed 's/\(..\)\(..\)\(..\)\(..\)\(..\)\(..\)/\1 \2 \3 \4 \5 \6/')
FORMATTED_UUID="${NEW_UUID_PART1}-${NEW_UUID_PART2}-${NEW_UUID_PART3}-${NEW_UUID_PART4}-${NEW_UUID_PART5}"

# 修改 uuid.bios
sed -i "s|uuid.bios = \".*\"|uuid.bios = \"${FORMATTED_UUID}\"|g" ${TARGET_VM_PATH}/${TARGET_VM_NAME}.vmx

# 修改 uuid.location
sed -i "s|uuid.location = \".*\"|uuid.location = \"${FORMATTED_UUID}\"|g" ${TARGET_VM_PATH}/${TARGET_VM_NAME}.vmx

# 生成新的网卡 MAC 地址
NEW_MAC=$(printf '%02x:%02x:%02x:%02x:%02x:%02x\n' $((RANDOM%256)) $((RANDOM%256)) $((RANDOM%256)) $((RANDOM%256)) $((RANDOM%256)) $((RANDOM%256)))
# 假设只有一个网卡，修改配置文件中的网卡 MAC 地址
sed -i "s|ethernet0.generatedAddress = \".*\"|ethernet0.generatedAddress = \"${NEW_MAC}\"|g" ${TARGET_VM_PATH}/${TARGET_VM_NAME}.vmx

# 注册虚拟机
VMID=$(vim-cmd solo/registervm ${TARGET_VM_PATH}/${TARGET_VM_NAME}.vmx)
echo "Registered VM with ID: ${VMID}"

# 启动虚拟机（可选）
vim-cmd vmsvc/power.on ${VMID}